<?php
define('ROVO_APP', true);
require_once '../../config.php';
require_once '../../Auth.php';

if (!$auth->isAdmin()) die('Unauthorized');

$msg_id = (int)($_GET['id'] ?? 0);

$sql = "SELECT cm.*, CONCAT(u.first_name, ' ', u.last_name) as replied_by_name
        FROM contact_messages cm
        LEFT JOIN users u ON cm.replied_by = u.id
        WHERE cm.id = ?";

$msg = $db->fetchOne($sql, [$msg_id]);

if (!$msg) die('Message not found');
?>

<div class="row">
    <div class="col-md-6">
        <h6>Sender Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Name:</strong></td>
                <td><?php echo htmlspecialchars($msg['name']); ?></td>
            </tr>
            <tr>
                <td><strong>Email:</strong></td>
                <td>
                    <a href="mailto:<?php echo htmlspecialchars($msg['email']); ?>">
                        <?php echo htmlspecialchars($msg['email']); ?>
                    </a>
                </td>
            </tr>
            <?php if ($msg['phone']): ?>
            <tr>
                <td><strong>Phone:</strong></td>
                <td>
                    <a href="tel:<?php echo htmlspecialchars($msg['phone']); ?>">
                        <?php echo htmlspecialchars($msg['phone']); ?>
                    </a>
                </td>
            </tr>
            <?php endif; ?>
            <tr>
                <td><strong>IP Address:</strong></td>
                <td><?php echo htmlspecialchars($msg['ip_address']); ?></td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h6>Message Details</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Subject:</strong></td>
                <td><?php echo htmlspecialchars($msg['subject'] ?? 'No Subject'); ?></td>
            </tr>
            <tr>
                <td><strong>Status:</strong></td>
                <td>
                    <?php
                    $badge_class = [
                        'new' => 'primary',
                        'read' => 'info',
                        'replied' => 'success',
                        'archived' => 'secondary'
                    ][$msg['status']] ?? 'secondary';
                    ?>
                    <span class="badge bg-<?php echo $badge_class; ?>">
                        <?php echo ucfirst($msg['status']); ?>
                    </span>
                </td>
            </tr>
            <tr>
                <td><strong>Received:</strong></td>
                <td><?php echo date('F d, Y H:i', strtotime($msg['created_at'])); ?></td>
            </tr>
            <?php if ($msg['replied_at']): ?>
            <tr>
                <td><strong>Replied:</strong></td>
                <td>
                    <?php echo date('F d, Y H:i', strtotime($msg['replied_at'])); ?>
                    <br>
                    <small class="text-muted">by <?php echo htmlspecialchars($msg['replied_by_name'] ?? 'Unknown'); ?></small>
                </td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
</div>

<div class="row mt-3">
    <div class="col-12">
        <h6>Message Content</h6>
        <div class="alert alert-light">
            <?php echo nl2br(htmlspecialchars($msg['message'])); ?>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-12">
        <h6>Quick Actions</h6>
        <a href="mailto:<?php echo htmlspecialchars($msg['email']); ?>?subject=Re: <?php echo urlencode($msg['subject'] ?? 'Your Message'); ?>" 
           class="btn btn-primary">
            <i class="fas fa-reply"></i> Reply via Email
        </a>
        
        <?php if ($msg['phone']): ?>
        <a href="tel:<?php echo htmlspecialchars($msg['phone']); ?>" class="btn btn-success">
            <i class="fas fa-phone"></i> Call
        </a>
        <?php endif; ?>
    </div>
</div>