<?php
// ==========================================
// FILE: admin/ajax/get-payment-details.php
// ==========================================
/* Save as: admin/ajax/get-payment-details.php */
define('ROVO_APP', true);
require_once '../../config.php';
require_once '../../Auth.php';

if (!$auth->isAdmin()) {
    die('Unauthorized');
}

$payment_id = (int)($_GET['id'] ?? 0);

$sql = "SELECT p.*, CONCAT(u.first_name, ' ', u.last_name) as user_name, u.email
        FROM payments p
        LEFT JOIN users u ON p.user_id = u.id
        WHERE p.id = ?";

$payment = $db->fetchOne($sql, [$payment_id]);

if (!$payment) {
    die('Payment not found');
}
?>

<div class="row">
    <div class="col-md-6">
        <h6>Payment Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Transaction Reference:</strong></td>
                <td><?php echo htmlspecialchars($payment['transaction_reference']); ?></td>
            </tr>
            <tr>
                <td><strong>Payment Type:</strong></td>
                <td><span class="badge bg-info"><?php echo ucfirst($payment['payment_type']); ?></span></td>
            </tr>
            <tr>
                <td><strong>Amount:</strong></td>
                <td><strong>₦<?php echo number_format($payment['amount'], 2); ?></strong></td>
            </tr>
            <tr>
                <td><strong>Payment Method:</strong></td>
                <td><?php echo ucfirst(str_replace('_', ' ', $payment['payment_method'])); ?></td>
            </tr>
            <tr>
                <td><strong>Status:</strong></td>
                <td>
                    <?php
                    $badge_class = [
                        'completed' => 'success',
                        'pending' => 'warning',
                        'failed' => 'danger',
                        'refunded' => 'secondary'
                    ][$payment['status']] ?? 'secondary';
                    ?>
                    <span class="badge bg-<?php echo $badge_class; ?>">
                        <?php echo ucfirst($payment['status']); ?>
                    </span>
                </td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-6">
        <h6>User Information</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Name:</strong></td>
                <td><?php echo htmlspecialchars($payment['user_name']); ?></td>
            </tr>
            <tr>
                <td><strong>Email:</strong></td>
                <td><?php echo htmlspecialchars($payment['email']); ?></td>
            </tr>
        </table>
        
        <h6>Dates</h6>
        <table class="table table-sm table-bordered">
            <tr>
                <td><strong>Created:</strong></td>
                <td><?php echo date('M d, Y H:i:s', strtotime($payment['created_at'])); ?></td>
            </tr>
            <?php if ($payment['paid_at']): ?>
            <tr>
                <td><strong>Paid At:</strong></td>
                <td><?php echo date('M d, Y H:i:s', strtotime($payment['paid_at'])); ?></td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
</div>

<?php if ($payment['description']): ?>
<div class="mt-3">
    <h6>Description</h6>
    <p><?php echo nl2br(htmlspecialchars($payment['description'])); ?></p>
</div>
<?php endif; ?>

<?php if ($payment['gateway_reference']): ?>
<div class="mt-3">
    <h6>Gateway Information</h6>
    <p><strong>Gateway Reference:</strong> <?php echo htmlspecialchars($payment['gateway_reference']); ?></p>
</div>
<?php endif; ?>
    