<?php
// ==========================================
// FILE: admin/settings.php
// ==========================================
define('ROVO_APP', true);
require_once '../config.php';
require_once '../Auth.php';

$page_title = 'Settings';

if (!$auth->hasRole('super_admin')) {
    $_SESSION['error'] = "Only super admin can access settings";
    header('Location: dashboard.php');
    exit;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_settings'])) {
    try {
        $db->beginTransaction();
        
        foreach ($_POST as $key => $value) {
            if ($key !== 'save_settings' && $key !== 'csrf_token') {
                $sql = "INSERT INTO settings (setting_key, setting_value, updated_by) 
                        VALUES (?, ?, ?) 
                        ON DUPLICATE KEY UPDATE setting_value = ?, updated_by = ?";
                $db->execute($sql, [$key, $value, $auth->getCurrentUser()['id'], $value, $auth->getCurrentUser()['id']]);
            }
        }
        
        $db->commit();
        $_SESSION['success'] = "Settings saved successfully";
        header('Location: settings.php');
        exit;
        
    } catch (Exception $e) {
        $db->rollBack();
        $error = "Failed to save settings";
    }
}

// Get all settings
$settings = [];
$result = $db->fetchAll("SELECT * FROM settings");
foreach ($result as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

include 'includes/header.php';
?>

<div class="page-header">
    <h1>System Settings</h1>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
            <li class="breadcrumb-item active">Settings</li>
        </ol>
    </nav>
</div>

<?php if (isset($_SESSION['success'])): ?>
<div class="alert alert-success alert-dismissible fade show">
    <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (isset($error)): ?>
<div class="alert alert-danger alert-dismissible fade show">
    <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<form method="POST" data-validate="true">
    <input type="hidden" name="csrf_token" value="<?php echo Security::generateCSRFToken(); ?>">
    
    <div class="row">
        <div class="col-lg-8">
            <!-- General Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">General Settings</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Site Name</label>
                        <input type="text" name="site_name" class="form-control" 
                               value="<?php echo htmlspecialchars($settings['site_name'] ?? 'RoVo Nigeria'); ?>">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Contact Email</label>
                            <input type="email" name="site_email" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['site_email'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Contact Phone</label>
                            <input type="text" name="site_phone" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['site_phone'] ?? ''); ?>">
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">WhatsApp Number</label>
                            <input type="text" name="whatsapp_number" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['whatsapp_number'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Currency</label>
                            <select name="currency" class="form-select">
                                <option value="NGN" <?php echo ($settings['currency'] ?? 'NGN') === 'NGN' ? 'selected' : ''; ?>>NGN - Nigerian Naira</option>
                                <option value="USD" <?php echo ($settings['currency'] ?? '') === 'USD' ? 'selected' : ''; ?>>USD - US Dollar</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Payment Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Payment Gateway Settings</h5>
                </div>
                <div class="card-body">
                    <h6>Paystack</h6>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Public Key</label>
                            <input type="text" name="paystack_public_key" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['paystack_public_key'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Secret Key</label>
                            <input type="password" name="paystack_secret_key" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['paystack_secret_key'] ?? ''); ?>">
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h6>Flutterwave</h6>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Public Key</label>
                            <input type="text" name="flutterwave_public_key" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['flutterwave_public_key'] ?? ''); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Secret Key</label>
                            <input type="password" name="flutterwave_secret_key" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['flutterwave_secret_key'] ?? ''); ?>">
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Rental Settings -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Rental Settings</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Commission Rate (%)</label>
                            <input type="number" name="commission_rate" class="form-control" 
                                   step="0.01" min="0" max="100"
                                   value="<?php echo htmlspecialchars($settings['commission_rate'] ?? '15'); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Document Verification Fee (₦)</label>
                            <input type="number" name="verification_fee" class="form-control" 
                                   step="1" min="0"
                                   value="<?php echo htmlspecialchars($settings['verification_fee'] ?? '3000'); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Save Settings -->
            <div class="card mb-4 position-sticky" style="top: 90px;">
                <div class="card-header">
                    <h5 class="mb-0">Actions</h5>
                </div>
                <div class="card-body">
                    <button type="submit" name="save_settings" class="btn btn-primary w-100 mb-2">
                        <i class="fas fa-save"></i> Save All Settings
                    </button>
                    
                    <a href="dashboard.php" class="btn btn-outline-secondary w-100">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                </div>
            </div>
            
            <!-- System Info -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">System Information</h5>
                </div>
                <div class="card-body">
                    <p class="mb-2"><strong>PHP Version:</strong> <?php echo phpversion(); ?></p>
                    <p class="mb-2"><strong>Server:</strong> <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></p>
                    <p class="mb-2"><strong>Database:</strong> MySQL <?php echo $db->getConnection()->getAttribute(PDO::ATTR_SERVER_VERSION); ?></p>
                    <p class="mb-0"><strong>Time Zone:</strong> <?php echo date_default_timezone_get(); ?></p>
                </div>
            </div>
        </div>
    </div>
</form>

<?php include 'includes/footer.php'; ?>
