<?php
if (!defined('ROVO_APP')) {
    die('Direct access not permitted');
}

if (!$auth->isLoggedIn() || $auth->isAdmin()) {
    header('Location: ../login.php');
    exit;
}

$current_user = $auth->getCurrentUser();

// Get unread notifications count
$notif_sql = "SELECT COUNT(*) as count FROM notifications WHERE user_id = ? AND is_read = 0";
$notif_count = $db->fetchOne($notif_sql, [$current_user['id']])['count'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Dashboard'; ?> - RoVo</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" rel="stylesheet">
    
    <!-- SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <link rel="icon" type="image/png" sizes="32x32" href="../favicon/favicon-32x32.png">
    
    <style>
        :root {
            --primary: #D4A017;
            --secondary: #B8974A;
            --light: #F8F8F8;
            --dark: #2A2A2A;
            --sidebar-width: 260px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f5f5f5;
            overflow-x: hidden;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: linear-gradient(180deg, #2A2A2A 0%, #1a1a1a 100%);
            transition: all 0.3s;
            z-index: 1000;
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }
        
        .sidebar.collapsed {
            width: 80px;
        }
        
        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h3 {
            font-family: 'Playfair Display', serif;
            color: var(--primary);
            font-size: 1.8rem;
            margin: 0;
            transition: opacity 0.3s;
        }
        
        .sidebar.collapsed .sidebar-header h3 {
            opacity: 0;
        }
        
        .user-profile-sidebar {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .user-avatar-sidebar {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            font-weight: 600;
            margin: 0 auto 10px;
            border: 3px solid rgba(212, 160, 23, 0.3);
        }
        
        .sidebar.collapsed .user-avatar-sidebar {
            width: 45px;
            height: 45px;
            font-size: 1rem;
        }
        
        .user-name-sidebar {
            color: white;
            font-weight: 600;
            transition: opacity 0.3s;
        }
        
        .sidebar.collapsed .user-name-sidebar {
            opacity: 0;
            display: none;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 0;
            margin: 20px 0;
        }
        
        .sidebar-menu li {
            margin-bottom: 5px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
        }
        
        .sidebar-menu a:hover {
            background: rgba(212, 160, 23, 0.1);
            color: var(--primary);
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .sidebar-menu a.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background: white;
        }
        
        .sidebar-menu i {
            font-size: 1.2rem;
            width: 30px;
            text-align: center;
        }
        
        .sidebar-menu span {
            margin-left: 15px;
            transition: opacity 0.3s;
        }
        
        .sidebar.collapsed .sidebar-menu span {
            opacity: 0;
            display: none;
        }
        
        /* Top Navbar */
        .top-navbar {
            position: fixed;
            top: 0;
            left: var(--sidebar-width);
            right: 0;
            height: 70px;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            transition: all 0.3s;
            z-index: 999;
        }
        
        .sidebar.collapsed + .main-content .top-navbar {
            left: 80px;
        }
        
        .navbar-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .menu-toggle {
            font-size: 1.5rem;
            color: var(--dark);
            cursor: pointer;
            transition: color 0.3s;
        }
        
        .menu-toggle:hover {
            color: var(--primary);
        }
        
        .page-title-nav {
            font-size: 1.3rem;
            font-weight: 600;
            color: var(--dark);
        }
        
        .navbar-right {
            display: flex;
            align-items: center;
            gap: 25px;
        }
        
        .notification-icon {
            position: relative;
            cursor: pointer;
            font-size: 1.3rem;
            color: var(--dark);
        }
        
        .notification-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: #ff4444;
            color: white;
            font-size: 0.7rem;
            padding: 2px 6px;
            border-radius: 10px;
            min-width: 18px;
            text-align: center;
        }
        
        .user-profile-nav {
            display: flex;
            align-items: center;
            gap: 10px;
            cursor: pointer;
            padding: 5px 15px;
            border-radius: 25px;
            transition: background 0.3s;
        }
        
        .user-profile-nav:hover {
            background: #f5f5f5;
        }
        
        .user-avatar-nav {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }
        
        .user-info-nav {
            text-align: left;
        }
        
        .user-name-nav {
            font-weight: 600;
            font-size: 0.9rem;
            color: var(--dark);
        }
        
        .user-role-nav {
            font-size: 0.75rem;
            color: #999;
        }
        
        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            padding-top: 70px;
            transition: margin-left 0.3s;
        }
        
        .sidebar.collapsed + .main-content {
            margin-left: 80px;
        }
        
        .content-wrapper {
            padding: 30px;
        }
        
        .page-header {
            margin-bottom: 30px;
        }
        
        .page-header h1 {
            font-family: 'Playfair Display', serif;
            color: var(--dark);
            font-size: 2rem;
            margin-bottom: 5px;
        }
        
        .breadcrumb {
            background: none;
            padding: 0;
            margin: 0;
            font-size: 0.9rem;
        }
        
        /* Cards */
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .card-header {
            background: white;
            border-bottom: 2px solid #f5f5f5;
            padding: 20px;
            font-weight: 600;
            color: var(--dark);
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
        }
        
        .stat-info h3 {
            font-size: 2rem;
            font-weight: 700;
            margin: 0;
            color: var(--dark);
        }
        
        .stat-info p {
            margin: 0;
            color: #999;
            font-size: 0.9rem;
        }
        
        /* Buttons */
        .btn-primary {
            background: var(--primary);
            border: none;
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background: var(--secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(212, 160, 23, 0.3);
        }
        
        /* Badge */
        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 500;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                left: -260px;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .top-navbar {
                left: 0;
            }
            
            .user-info-nav {
                display: none;
            }
        }
        
        /* Dropdown */
        .dropdown-menu {
            border: none;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            border-radius: 10px;
        }
        
        .dropdown-item {
            padding: 10px 20px;
            transition: background 0.3s;
        }
        
        .dropdown-item:hover {
            background: #f5f5f5;
        }
        
        .dropdown-item i {
            width: 20px;
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <h3>RoVo</h3>
        </div>
        
        <div class="user-profile-sidebar">
            <div class="user-avatar-sidebar">
                <?php echo strtoupper(substr($current_user['first_name'], 0, 1) . substr($current_user['last_name'], 0, 1)); ?>
            </div>
            <div class="user-name-sidebar">
                <?php echo htmlspecialchars($current_user['first_name'] . ' ' . $current_user['last_name']); ?>
            </div>
        </div>
        
        <ul class="sidebar-menu">
            <li>
                <a href="dashboard.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            
            <li>
                <a href="browse-properties.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'browse-properties.php' ? 'active' : ''; ?>">
                    <i class="fas fa-search"></i>
                    <span>Browse Properties</span>
                </a>
            </li>
            
            <li>
                <a href="my-applications.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'my-applications.php' ? 'active' : ''; ?>">
                    <i class="fas fa-file-alt"></i>
                    <span>My Applications</span>
                </a>
            </li>
            
            <li>
                <a href="favorites.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'favorites.php' ? 'active' : ''; ?>">
                    <i class="fas fa-heart"></i>
                    <span>Favorites</span>
                </a>
            </li>
            
            <li>
                <a href="payments.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'payments.php' ? 'active' : ''; ?>">
                    <i class="fas fa-credit-card"></i>
                    <span>Payments</span>
                </a>
            </li>
            
            <li>
                <a href="documents.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'documents.php' ? 'active' : ''; ?>">
                    <i class="fas fa-folder"></i>
                    <span>Documents</span>
                </a>
            </li>
            
            <li>
                <a href="notifications.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'notifications.php' ? 'active' : ''; ?>">
                    <i class="fas fa-bell"></i>
                    <span>Notifications</span>
                    <?php if ($notif_count > 0): ?>
                    <span class="badge bg-danger ms-auto"><?php echo $notif_count; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            
            <li>
                <a href="profile.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'profile.php' ? 'active' : ''; ?>">
                    <i class="fas fa-user"></i>
                    <span>Profile Settings</span>
                </a>
            </li>
            
            <li>
                <a href="../logout.php">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </li>
        </ul>
    </div>
    
    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Navbar -->
        <nav class="top-navbar">
            <div class="navbar-left">
                <i class="fas fa-bars menu-toggle" id="menuToggle"></i>
                <div class="page-title-nav"><?php echo $page_title ?? 'Dashboard'; ?></div>
            </div>
            
            <div class="navbar-right">
                <div class="notification-icon dropdown" data-bs-toggle="dropdown">
                    <i class="fas fa-bell"></i>
                    <?php if ($notif_count > 0): ?>
                    <span class="notification-badge"><?php echo $notif_count; ?></span>
                    <?php endif; ?>
                    
                    <ul class="dropdown-menu dropdown-menu-end" style="width: 300px;">
                        <li class="dropdown-header">
                            <strong>Notifications</strong>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="notifications.php">View All Notifications</a></li>
                    </ul>
                </div>
                
                <div class="user-profile-nav dropdown" data-bs-toggle="dropdown">
                    <div class="user-avatar-nav">
                        <?php echo strtoupper(substr($current_user['first_name'], 0, 1) . substr($current_user['last_name'], 0, 1)); ?>
                    </div>
                    <div class="user-info-nav">
                        <div class="user-name-nav"><?php echo htmlspecialchars($current_user['first_name']); ?></div>
                        <div class="user-role-nav">Member</div>
                    </div>
                    <i class="fas fa-chevron-down" style="margin-left: 10px;"></i>
                    
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user"></i> Profile</a></li>
                        <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog"></i> Settings</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="../logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                    </ul>
                </div>
            </div>
        </nav>
        
        <!-- Page Content -->
        <div class="content-wrapper"><?php echo "\n"; ?>