<!-- Step 1: Personal Information -->
<div class="form-section">
    <h5><i class="fas fa-user"></i> Personal Information</h5>
    <p class="text-muted">Please provide your accurate personal details as they appear on official documents.</p>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Date of Birth <span class="text-danger">*</span></label>
            <input type="date" name="date_of_birth" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['date_of_birth'] ?? ''); ?>"
                   max="<?php echo date('Y-m-d', strtotime('-18 years')); ?>">
            <small class="text-muted">You must be 18 years or older</small>
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Nationality</label>
            <select name="nationality" class="form-select">
                <option value="Nigerian" selected>Nigerian</option>
                <option value="Other">Other</option>
            </select>
        </div>
    </div>
    
    <div class="mb-3">
        <label class="form-label">Residential Address <span class="text-danger">*</span></label>
        <input type="text" name="address" class="form-control" required
               value="<?php echo htmlspecialchars($current_user['address'] ?? ''); ?>"
               placeholder="e.g., 123 Main Street, Ikeja">
        <small class="text-muted">Enter your current residential address</small>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label class="form-label">City <span class="text-danger">*</span></label>
            <input type="text" name="city" class="form-control" required
                   value="<?php echo htmlspecialchars($current_user['city'] ?? ''); ?>"
                   placeholder="e.g., Lagos">
        </div>
        
        <div class="col-md-4 mb-3">
            <label class="form-label">State of Residence <span class="text-danger">*</span></label>
            <select name="state" class="form-select" required>
                <option value="">Select State</option>
                <?php foreach ($nigerian_states as $state): ?>
                <option value="<?php echo $state; ?>" <?php echo ($current_user['state'] ?? '') === $state ? 'selected' : ''; ?>>
                    <?php echo $state; ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="col-md-4 mb-3">
            <label class="form-label">State of Origin <span class="text-danger">*</span></label>
            <select name="state_of_origin" class="form-select" required>
                <option value="">Select State</option>
                <?php foreach ($nigerian_states as $state): ?>
                <option value="<?php echo $state; ?>" <?php echo ($saved_data['state_of_origin'] ?? '') === $state ? 'selected' : ''; ?>>
                    <?php echo $state; ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
</div>

<div class="form-section">
    <h5><i class="fas fa-user-friends"></i> Next of Kin Information</h5>
    <p class="text-muted">Provide contact details for your next of kin in case of emergency.</p>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label class="form-label">Next of Kin Full Name <span class="text-danger">*</span></label>
            <input type="text" name="next_of_kin_name" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['next_of_kin_name'] ?? ''); ?>"
                   placeholder="e.g., John Doe">
        </div>
        
        <div class="col-md-6 mb-3">
            <label class="form-label">Next of Kin Phone <span class="text-danger">*</span></label>
            <input type="tel" name="next_of_kin_phone" class="form-control" required
                   value="<?php echo htmlspecialchars($saved_data['next_of_kin_phone'] ?? ''); ?>"
                   placeholder="+234 800 000 0000" 
                   pattern="^(\+?234|0)[789]\d{9}$">
            <small class="text-muted">Format: +234 or 0 followed by 10 digits</small>
        </div>
    </div>
</div>

<div class="alert alert-info">
    <i class="fas fa-info-circle"></i> 
    <strong>Note:</strong> All information provided will be verified. Please ensure accuracy to avoid delays in your application process.
</div>