<!-- Step 3: Employment & Income Information -->
<div class="form-section">
    <h5><i class="fas fa-briefcase"></i> Employment Information</h5>
    <p class="text-muted">Tell us about your current employment status and income.</p>
    
    <div class="mb-3">
        <label class="form-label">Employment Status <span class="text-danger">*</span></label>
        <select name="employment_status" class="form-select" required id="employmentStatus">
            <option value="">Select Employment Status</option>
            <option value="employed" <?php echo ($saved_data['employment_status'] ?? '') === 'employed' ? 'selected' : ''; ?>>Employed (Full-time/Part-time)</option>
            <option value="self_employed" <?php echo ($saved_data['employment_status'] ?? '') === 'self_employed' ? 'selected' : ''; ?>>Self-Employed</option>
            <option value="business_owner" <?php echo ($saved_data['employment_status'] ?? '') === 'business_owner' ? 'selected' : ''; ?>>Business Owner</option>
            <option value="student" <?php echo ($saved_data['employment_status'] ?? '') === 'student' ? 'selected' : ''; ?>>Student</option>
            <option value="unemployed" <?php echo ($saved_data['employment_status'] ?? '') === 'unemployed' ? 'selected' : ''; ?>>Unemployed</option>
            <option value="retired" <?php echo ($saved_data['employment_status'] ?? '') === 'retired' ? 'selected' : ''; ?>>Retired</option>
        </select>
    </div>
    
    <div class="mb-3">
        <label class="form-label">Monthly Income (₦) <span class="text-danger">*</span></label>
        <input type="number" name="monthly_income" class="form-control" required min="0" step="1000"
               value="<?php echo htmlspecialchars($saved_data['monthly_income'] ?? ''); ?>"
               placeholder="e.g., 150000">
        <small class="text-muted">Enter your average monthly income in Naira</small>
    </div>
</div>

<!-- For Employed -->
<div id="employedSection" style="display: none;">
    <div class="form-section">
        <h5><i class="fas fa-building"></i> Employment Details</h5>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">Company/Organization Name <span class="text-danger">*</span></label>
                <input type="text" name="company_name" class="form-control"
                       value="<?php echo htmlspecialchars($saved_data['company_name'] ?? ''); ?>"
                       placeholder="e.g., ABC Company Limited">
            </div>
            
            <div class="col-md-6 mb-3">
                <label class="form-label">Job Title/Position <span class="text-danger">*</span></label>
                <input type="text" name="job_title" class="form-control"
                       value="<?php echo htmlspecialchars($saved_data['job_title'] ?? ''); ?>"
                       placeholder="e.g., Senior Accountant">
            </div>
        </div>
        
        <div class="mb-3">
            <label class="form-label">Company Address <span class="text-danger">*</span></label>
            <textarea name="company_address" class="form-control" rows="2"
                      placeholder="Enter complete company address"><?php echo htmlspecialchars($saved_data['company_address'] ?? ''); ?></textarea>
        </div>
        
        <div class="mb-3">
            <label class="form-label">Employment Letter <span class="text-danger">*</span></label>
            <div class="upload-box" onclick="document.getElementById('employmentLetter').click()">
                <i class="fas fa-file-upload fa-2x text-primary mb-2"></i>
                <p class="mb-0">Click to upload Employment/Confirmation Letter</p>
                <p class="mb-0 small text-muted">PDF, JPG, PNG (Max 5MB)</p>
            </div>
            <input type="file" id="employmentLetter" name="employment_letter" class="d-none" 
                   accept=".pdf,.jpg,.jpeg,.png">
            <div id="employmentLetterPreview" class="mt-2"></div>
            <small class="text-muted">Upload a letter from your employer confirming your employment</small>
        </div>
    </div>
</div>

<!-- For Self-Employed / Business Owner -->
<div id="businessSection" style="display: none;">
    <div class="form-section">
        <h5><i class="fas fa-store"></i> Business Details</h5>
        
        <div class="mb-3">
            <label class="form-label">Business Name <span class="text-danger">*</span></label>
            <input type="text" name="business_name" class="form-control"
                   value="<?php echo htmlspecialchars($saved_data['business_name'] ?? ''); ?>"
                   placeholder="e.g., XYZ Trading Enterprise">
        </div>
        
        <div class="mb-3">
            <label class="form-label">Business Registration Document</label>
            <div class="upload-box" onclick="document.getElementById('businessReg').click()">
                <i class="fas fa-file-upload fa-2x text-primary mb-2"></i>
                <p class="mb-0">Click to upload CAC Certificate or Business Registration</p>
                <p class="mb-0 small text-muted">PDF, JPG, PNG (Max 5MB)</p>
            </div>
            <input type="file" id="businessReg" name="business_registration" class="d-none" 
                   accept=".pdf,.jpg,.jpeg,.png">
            <div id="businessRegPreview" class="mt-2"></div>
            <small class="text-muted">Upload CAC certificate or business registration document (Optional but recommended)</small>
        </div>
    </div>
</div>

<!-- Bank Statement (Required for all) -->
<div class="form-section">
    <h5><i class="fas fa-university"></i> Financial Verification</h5>
    
    <div class="mb-3">
        <label class="form-label">Bank Statement <span class="text-danger">*</span></label>
        <div class="upload-box" onclick="document.getElementById('bankStatement').click()">
            <i class="fas fa-file-upload fa-2x text-primary mb-2"></i>
            <p class="mb-0">Click to upload Bank Statement</p>
            <p class="mb-0 small text-muted">PDF, JPG, PNG (Max 5MB)</p>
        </div>
        <input type="file" id="bankStatement" name="bank_statement" class="d-none" 
               accept=".pdf,.jpg,.jpeg,.png" required>
        <div id="bankStatementPreview" class="mt-2"></div>
        <small class="text-muted">
            <strong>Required:</strong> 3-6 months bank statement showing regular income.
            <br>For employed: 3 months minimum | For self-employed/business: 6 months minimum
        </small>
    </div>
</div>

<div class="alert alert-info">
    <i class="fas fa-lightbulb"></i> 
    <strong>Tip:</strong> Providing accurate employment and income information helps us process your application faster 
    and increases your approval chances.
</div>

<style>
    .upload-box {
        border: 2px dashed #ddd;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .upload-box:hover {
        border-color: var(--primary);
        background: rgba(212, 160, 23, 0.05);
    }
    
    .file-preview {
        padding: 10px;
        background: #f8f9fa;
        border-radius: 8px;
        border: 1px solid #dee2e6;
    }
</style>

<script>
    // Show/hide sections based on employment status
    document.getElementById('employmentStatus').addEventListener('change', function() {
        const status = this.value;
        const employedSection = document.getElementById('employedSection');
        const businessSection = document.getElementById('businessSection');
        
        // Hide all sections first
        employedSection.style.display = 'none';
        businessSection.style.display = 'none';
        
        // Show relevant section
        if (status === 'employed') {
            employedSection.style.display = 'block';
            // Make employed fields required
            employedSection.querySelectorAll('input[type="text"], textarea').forEach(el => {
                el.setAttribute('required', 'required');
            });
            businessSection.querySelectorAll('input[type="text"]').forEach(el => {
                el.removeAttribute('required');
            });
        } else if (status === 'self_employed' || status === 'business_owner') {
            businessSection.style.display = 'block';
            // Make business fields required
            businessSection.querySelector('input[name="business_name"]').setAttribute('required', 'required');
            employedSection.querySelectorAll('input, textarea').forEach(el => {
                el.removeAttribute('required');
            });
        } else {
            // Remove all section requirements for other statuses
            employedSection.querySelectorAll('input, textarea').forEach(el => {
                el.removeAttribute('required');
            });
            businessSection.querySelectorAll('input').forEach(el => {
                el.removeAttribute('required');
            });
        }
    });
    
    // Trigger on page load
    document.getElementById('employmentStatus').dispatchEvent(new Event('change'));
    
    // File upload preview
    function setupFilePreview(inputId, previewId) {
        document.getElementById(inputId).addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                if (file.size > 5242880) {
                    alert('File size must be less than 5MB');
                    this.value = '';
                    return;
                }
                
                const icon = file.type.includes('pdf') ? 'fa-file-pdf text-danger' : 'fa-file-image text-primary';
                document.getElementById(previewId).innerHTML = 
                    `<div class="file-preview">
                        <i class="fas ${icon} fa-2x"></i>
                        <p class="mb-0 mt-2"><strong>${file.name}</strong></p>
                        <small class="text-muted">${(file.size / 1024 / 1024).toFixed(2)} MB</small>
                        <small class="text-success d-block"><i class="fas fa-check"></i> Ready to upload</small>
                    </div>`;
            }
        });
    }
    
    setupFilePreview('employmentLetter', 'employmentLetterPreview');
    setupFilePreview('businessReg', 'businessRegPreview');
    setupFilePreview('bankStatement', 'bankStatementPreview');
</script>