<!-- Step 5: Review & Submit -->
<div class="form-section">
    <h5><i class="fas fa-check-circle"></i> Review Your Information</h5>
    <p class="text-muted">Please review all information before submitting. You can go back to edit any section.</p>
    
    <div class="alert alert-info">
        <i class="fas fa-info-circle"></i>
        <strong>What happens next?</strong>
        <ul class="mb-0 mt-2">
            <li>Your profile will be submitted for verification</li>
            <li>Admin will review your documents and information</li>
            <li>BVN verification will be conducted (if provided)</li>
            <li>You'll be notified once verification is complete</li>
            <li>Verification typically takes 2-3 business days</li>
        </ul>
    </div>
</div>

<!-- Personal Information Summary -->
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h6 class="mb-0"><i class="fas fa-user"></i> Personal Information</h6>
        <a href="?step=1" class="btn btn-sm btn-outline-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 mb-2">
                <strong>Full Name:</strong><br>
                <?php echo htmlspecialchars($current_user['first_name'] . ' ' . $current_user['last_name']); ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Date of Birth:</strong><br>
                <?php echo isset($saved_data['date_of_birth']) ? date('F d, Y', strtotime($saved_data['date_of_birth'])) : 'Not provided'; ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Email:</strong><br>
                <?php echo htmlspecialchars($current_user['email']); ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Phone:</strong><br>
                <?php echo htmlspecialchars($current_user['phone']); ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Address:</strong><br>
                <?php echo htmlspecialchars($current_user['address'] ?? 'Not provided'); ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>City, State:</strong><br>
                <?php echo htmlspecialchars(($current_user['city'] ?? '') . ', ' . ($current_user['state'] ?? '')); ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>State of Origin:</strong><br>
                <?php echo htmlspecialchars($saved_data['state_of_origin'] ?? 'Not provided'); ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Next of Kin:</strong><br>
                <?php echo htmlspecialchars($saved_data['next_of_kin_name'] ?? 'Not provided'); ?>
                <?php if (!empty($saved_data['next_of_kin_phone'])): ?>
                    <br><small class="text-muted"><?php echo htmlspecialchars($saved_data['next_of_kin_phone']); ?></small>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Identity Verification Summary -->
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h6 class="mb-0"><i class="fas fa-id-card"></i> Identity Verification</h6>
        <a href="?step=2" class="btn btn-sm btn-outline-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 mb-2">
                <strong>BVN:</strong><br>
                <?php echo !empty($current_user['bvn']) ? '***' . substr($current_user['bvn'], -4) : 'Not provided'; ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>NIN:</strong><br>
                <?php echo !empty($current_user['nin']) ? '***' . substr($current_user['nin'], -4) : 'Not provided'; ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>ID Type:</strong><br>
                <?php echo isset($saved_data['id_type']) ? ucwords(str_replace('_', ' ', $saved_data['id_type'])) : 'Not provided'; ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>ID Number:</strong><br>
                <?php echo htmlspecialchars($saved_data['id_number'] ?? 'Not provided'); ?>
            </div>
        </div>
        
        <div class="row mt-3">
            <div class="col-12">
                <strong>Uploaded Documents:</strong>
                <div class="d-flex gap-2 mt-2 flex-wrap">
                    <?php if (!empty($saved_data['id_front_image'])): ?>
                    <span class="badge bg-success"><i class="fas fa-check"></i> ID Front</span>
                    <?php endif; ?>
                    
                    <?php if (!empty($saved_data['id_back_image'])): ?>
                    <span class="badge bg-success"><i class="fas fa-check"></i> ID Back</span>
                    <?php endif; ?>
                    
                    <?php if (!empty($saved_data['passport_photo'])): ?>
                    <span class="badge bg-success"><i class="fas fa-check"></i> Passport Photo</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Employment Summary -->
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h6 class="mb-0"><i class="fas fa-briefcase"></i> Employment & Income</h6>
        <a href="?step=3" class="btn btn-sm btn-outline-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 mb-2">
                <strong>Employment Status:</strong><br>
                <?php echo isset($saved_data['employment_status']) ? ucwords(str_replace('_', ' ', $saved_data['employment_status'])) : 'Not provided'; ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Monthly Income:</strong><br>
                ₦<?php echo number_format($saved_data['monthly_income'] ?? 0); ?>
            </div>
            
            <?php if (($saved_data['employment_status'] ?? '') === 'employed'): ?>
            <div class="col-md-6 mb-2">
                <strong>Company:</strong><br>
                <?php echo htmlspecialchars($saved_data['company_name'] ?? 'Not provided'); ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Job Title:</strong><br>
                <?php echo htmlspecialchars($saved_data['job_title'] ?? 'Not provided'); ?>
            </div>
            <?php endif; ?>
            
            <?php if (in_array($saved_data['employment_status'] ?? '', ['self_employed', 'business_owner'])): ?>
            <div class="col-md-12 mb-2">
                <strong>Business Name:</strong><br>
                <?php echo htmlspecialchars($saved_data['business_name'] ?? 'Not provided'); ?>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="row mt-3">
            <div class="col-12">
                <strong>Uploaded Documents:</strong>
                <div class="d-flex gap-2 mt-2 flex-wrap">
                    <?php if (!empty($saved_data['employment_letter'])): ?>
                    <span class="badge bg-success"><i class="fas fa-check"></i> Employment Letter</span>
                    <?php endif; ?>
                    
                    <?php if (!empty($saved_data['business_registration'])): ?>
                    <span class="badge bg-success"><i class="fas fa-check"></i> Business Registration</span>
                    <?php endif; ?>
                    
                    <?php if (!empty($saved_data['bank_statement'])): ?>
                    <span class="badge bg-success"><i class="fas fa-check"></i> Bank Statement</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Guarantor Summary -->
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h6 class="mb-0"><i class="fas fa-user-shield"></i> Guarantor Information</h6>
        <a href="?step=4" class="btn btn-sm btn-outline-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
    <div class="card-body">
        <!-- Guarantor 1 -->
        <div class="mb-3">
            <h6 class="text-primary">Guarantor 1</h6>
            <div class="row">
                <div class="col-md-6 mb-2">
                    <strong>Name:</strong><br>
                    <?php echo htmlspecialchars($saved_data['guarantor1_name'] ?? 'Not provided'); ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Relationship:</strong><br>
                    <?php echo isset($saved_data['guarantor1_relationship']) ? ucwords($saved_data['guarantor1_relationship']) : 'Not provided'; ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Phone:</strong><br>
                    <?php echo htmlspecialchars($saved_data['guarantor1_phone'] ?? 'Not provided'); ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Occupation:</strong><br>
                    <?php echo htmlspecialchars($saved_data['guarantor1_occupation'] ?? 'Not provided'); ?>
                </div>
            </div>
        </div>
        
        <!-- Guarantor 2 (if provided) -->
        <?php if (!empty($saved_data['guarantor2_name'])): ?>
        <div class="mb-3 pt-3 border-top">
            <h6 class="text-secondary">Guarantor 2</h6>
            <div class="row">
                <div class="col-md-6 mb-2">
                    <strong>Name:</strong><br>
                    <?php echo htmlspecialchars($saved_data['guarantor2_name']); ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Relationship:</strong><br>
                    <?php echo ucwords($saved_data['guarantor2_relationship'] ?? ''); ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Phone:</strong><br>
                    <?php echo htmlspecialchars($saved_data['guarantor2_phone'] ?? ''); ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Occupation:</strong><br>
                    <?php echo htmlspecialchars($saved_data['guarantor2_occupation'] ?? ''); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if (!empty($saved_data['guarantor_form'])): ?>
        <div class="mt-3">
            <span class="badge bg-success"><i class="fas fa-check"></i> Guarantor Form Uploaded</span>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Terms and Conditions -->
<div class="form-section">
    <h5><i class="fas fa-file-contract"></i> Terms & Conditions</h5>
    
    <div class="card mb-3">
        <div class="card-body">
            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="terms_accepted" id="terms" required>
                <label class="form-check-label" for="terms">
                    I have read and agree to the <a href="#" data-bs-toggle="modal" data-bs-target="#termsModal">Terms and Conditions</a>
                    <span class="text-danger">*</span>
                </label>
            </div>
            
            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="bvn_consent" id="bvnConsent" required>
                <label class="form-check-label" for="bvnConsent">
                    I consent to BVN verification and data processing as outlined in the 
                    <a href="#" data-bs-toggle="modal" data-bs-target="#privacyModal">Privacy Policy</a>
                    <span class="text-danger">*</span>
                </label>
            </div>
            
            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="data_consent" id="dataConsent" required>
                <label class="form-check-label" for="dataConsent">
                    I consent to my data being stored and processed in accordance with NDPR (Nigeria Data Protection Regulation)
                    <span class="text-danger">*</span>
                </label>
            </div>
        </div>
    </div>
    
    <div class="alert alert-success">
        <i class="fas fa-shield-alt"></i>
        <strong>Your Data is Safe:</strong> All information is encrypted and stored securely. 
        We comply with NDPR and never share your personal information without consent.
    </div>
</div>

<!-- Terms Modal -->
<div class="modal fade" id="termsModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Terms and Conditions</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <h6>1. Acceptance of Terms</h6>
                <p>By submitting this profile, you agree to provide accurate and truthful information. Any false information may result in immediate rejection and potential legal action.</p>
                
                <h6>2. Verification Process</h6>
                <p>Your profile will undergo verification which includes:</p>
                <ul>
                    <li>BVN verification (if provided)</li>
                    <li>Document authentication</li>
                    <li>Employment verification</li>
                    <li>Guarantor confirmation</li>
                </ul>
                
                <h6>3. Data Usage</h6>
                <p>Your data will be used solely for:</p>
                <ul>
                    <li>Identity verification</li>
                    <li>Processing rental applications</li>
                    <li>Communication regarding your account</li>
                    <li>Compliance with legal requirements</li>
                </ul>
                
                <h6>4. Obligations</h6>
                <p>You agree to:</p>
                <ul>
                    <li>Provide accurate and current information</li>
                    <li>Update your profile if information changes</li>
                    <li>Notify us of any security concerns</li>
                    <li>Not share your account credentials</li>
                </ul>
                
                <h6>5. Account Suspension</h6>
                <p>We reserve the right to suspend or terminate accounts that:</p>
                <ul>
                    <li>Provide false information</li>
                    <li>Violate terms of service</li>
                    <li>Engage in fraudulent activities</li>
                    <li>Fail verification checks</li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Privacy Policy Modal -->
<div class="modal fade" id="privacyModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Privacy Policy & BVN Consent</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <h6>BVN Verification</h6>
                <p>Your Bank Verification Number (BVN) will be used to:</p>
                <ul>
                    <li>Verify your identity</li>
                    <li>Prevent fraud and identity theft</li>
                    <li>Comply with CBN regulations</li>
                    <li>Ensure you meet eligibility criteria</li>
                </ul>
                
                <h6>Data Protection</h6>
                <p>We are committed to protecting your data in accordance with NDPR:</p>
                <ul>
                    <li>All data is encrypted at rest and in transit</li>
                    <li>Access is restricted to authorized personnel only</li>
                    <li>We use CBN-licensed verification partners</li>
                    <li>Data is never sold to third parties</li>
                    <li>You can request data deletion at any time</li>
                </ul>
                
                <h6>Your Rights</h6>
                <p>Under NDPR, you have the right to:</p>
                <ul>
                    <li>Access your personal data</li>
                    <li>Request corrections to your data</li>
                    <li>Request deletion of your data</li>
                    <li>Withdraw consent at any time</li>
                    <li>File complaints with NITDA</li>
                </ul>
                
                <h6>Data Retention</h6>
                <p>We retain your data for:</p>
                <ul>
                    <li>As long as your account is active</li>
                    <li>Up to 7 years for compliance purposes</li>
                    <li>Until you request deletion (subject to legal requirements)</li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
    .card {
        transition: all 0.3s;
    }
    
    .card:hover {
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .form-check-input:required ~ .form-check-label::after {
        content: "*";
        color: #dc3545;
        margin-left: 4px;
    }
</style>

<script>
    $(document).ready(function() {
        // Validate all checkboxes before submission
        $('form').submit(function(e) {
            const terms = $('#terms').is(':checked');
            const bvn = $('#bvnConsent').is(':checked');
            const data = $('#dataConsent').is(':checked');
            
            if (!terms || !bvn || !data) {
                e.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'Required Consent',
                    text: 'Please accept all terms and consents to proceed'
                });
                return false;
            }
            
            // Show confirmation dialog
            e.preventDefault();
            Swal.fire({
                title: 'Submit Profile?',
                html: `
                    <p>You are about to submit your profile for verification.</p>
                    <p><strong>This action cannot be undone.</strong></p>
                    <p>Please ensure all information is accurate.</p>
                `,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#D4A017',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, Submit Profile',
                cancelButtonText: 'Review Again'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Show loading
                    Swal.fire({
                        title: 'Submitting...',
                        html: 'Please wait while we process your profile',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });
                    
                    // Submit the form
                    e.target.submit();
                }
            });
        });
    });
</script>