<?php
define('ROVO_APP', true);
require_once '../config.php';
require_once '../Auth.php';

$page_title = 'Verification Status';

if (!$auth->isLoggedIn() || $auth->isAdmin()) {
    header('Location: ../login.php');
    exit;
}

$current_user = $auth->getCurrentUser();

// Get profile verification data
$sql = "SELECT * FROM user_profile_data WHERE user_id = ?";
$profile_data = $db->fetchOne($sql, [$current_user['id']]);

// Determine verification status
$has_profile = !empty($profile_data);
$is_pending = $current_user['status'] === 'pending';
$is_active = $current_user['status'] === 'active';
$is_rejected = $current_user['status'] === 'suspended';

include 'includes/header.php';
?>

<style>
    .status-card {
        max-width: 700px;
        margin: 50px auto;
        text-align: center;
    }
    
    .status-icon {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 30px;
        font-size: 4rem;
    }
    
    .status-icon.pending {
        background: rgba(255, 193, 7, 0.1);
        color: #ffc107;
    }
    
    .status-icon.active {
        background: rgba(40, 167, 69, 0.1);
        color: #28a745;
    }
    
    .status-icon.rejected {
        background: rgba(220, 53, 69, 0.1);
        color: #dc3545;
    }
    
    .timeline {
        position: relative;
        padding: 20px 0;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 50%;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e0e0e0;
        transform: translateX(-50%);
    }
    
    .timeline-item {
        position: relative;
        margin-bottom: 30px;
        display: flex;
        align-items: center;
    }
    
    .timeline-item::before {
        content: '';
        position: absolute;
        left: 50%;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        background: white;
        border: 3px solid #e0e0e0;
        transform: translateX(-50%);
        z-index: 2;
    }
    
    .timeline-item.completed::before {
        background: #28a745;
        border-color: #28a745;
    }
    
    .timeline-item.active::before {
        background: #ffc107;
        border-color: #ffc107;
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0%, 100% {
            transform: translateX(-50%) scale(1);
        }
        50% {
            transform: translateX(-50%) scale(1.2);
        }
    }
    
    .timeline-content {
        background: white;
        padding: 15px 20px;
        border-radius: 10px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        width: 45%;
    }
    
    .timeline-item:nth-child(odd) .timeline-content {
        margin-right: auto;
        text-align: right;
    }
    
    .timeline-item:nth-child(even) .timeline-content {
        margin-left: auto;
        text-align: left;
    }
    
    @media (max-width: 768px) {
        .timeline::before {
            left: 20px;
        }
        
        .timeline-item::before {
            left: 20px;
        }
        
        .timeline-content {
            width: calc(100% - 50px);
            margin-left: 50px !important;
            text-align: left !important;
        }
    }
</style>

<div class="status-card">
    <?php if (!$has_profile): ?>
        <!-- No Profile Submitted -->
        <div class="card">
            <div class="card-body p-5">
                <div class="status-icon pending">
                    <i class="fas fa-exclamation-circle"></i>
                </div>
                
                <h2 class="mb-3">Profile Not Submitted</h2>
                <p class="text-muted mb-4">
                    You haven't completed your profile yet. Complete your profile to start applying for properties.
                </p>
                
                <a href="complete-profile.php" class="btn btn-primary btn-lg">
                    <i class="fas fa-user-edit"></i> Complete Profile Now
                </a>
            </div>
        </div>
        
    <?php elseif ($is_pending): ?>
        <!-- Pending Verification -->
        <div class="card">
            <div class="card-body p-5">
                <div class="status-icon pending">
                    <i class="fas fa-clock"></i>
                </div>
                
                <h2 class="mb-3">Verification In Progress</h2>
                <p class="text-muted mb-4">
                    Thank you for submitting your profile! Our team is currently reviewing your information and documents.
                </p>
                
                <div class="alert alert-info text-start">
                    <h6><i class="fas fa-info-circle"></i> What's Happening Now?</h6>
                    <ul class="mb-0">
                        <li>Your documents are being verified</li>
                        <li>BVN verification is in process (if provided)</li>
                        <li>Employment details are being confirmed</li>
                        <li>Guarantors may be contacted</li>
                    </ul>
                </div>
                
                <div class="row text-center mb-4">
                    <div class="col-md-6 mb-3">
                        <div class="p-3 bg-light rounded">
                            <h6 class="text-muted mb-2">Submitted</h6>
                            <strong><?php echo date('M d, Y', strtotime($profile_data['created_at'])); ?></strong>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <div class="p-3 bg-light rounded">
                            <h6 class="text-muted mb-2">Expected Response</h6>
                            <strong><?php echo date('M d, Y', strtotime($profile_data['created_at'] . ' +3 days')); ?></strong>
                        </div>
                    </div>
                </div>
                
                <p class="small text-muted">
                    <i class="fas fa-bell"></i> You'll receive an email and notification once verification is complete.
                </p>
                
                <div class="mt-4">
                    <a href="dashboard.php" class="btn btn-outline-primary">
                        <i class="fas fa-home"></i> Go to Dashboard
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Verification Timeline -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0">Verification Process</h5>
            </div>
            <div class="card-body">
                <div class="timeline">
                    <div class="timeline-item completed">
                        <div class="timeline-content">
                            <h6 class="mb-1">Profile Submitted</h6>
                            <small class="text-muted">
                                <?php echo date('M d, Y H:i', strtotime($profile_data['created_at'])); ?>
                            </small>
                        </div>
                    </div>
                    
                    <div class="timeline-item active">
                        <div class="timeline-content">
                            <h6 class="mb-1">Document Review</h6>
                            <small class="text-muted">In Progress</small>
                        </div>
                    </div>
                    
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h6 class="mb-1">BVN Verification</h6>
                            <small class="text-muted">Pending</small>
                        </div>
                    </div>
                    
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h6 class="mb-1">Final Approval</h6>
                            <small class="text-muted">Pending</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    <?php elseif ($is_active): ?>
        <!-- Verified Successfully -->
        <div class="card">
            <div class="card-body p-5">
                <div class="status-icon active">
                    <i class="fas fa-check-circle"></i>
                </div>
                
                <h2 class="mb-3">Profile Verified! 🎉</h2>
                <p class="text-muted mb-4">
                    Congratulations! Your profile has been successfully verified. You can now apply for properties.
                </p>
                
                <?php if (!empty($profile_data['admin_verified_at'])): ?>
                <p class="small text-muted">
                    Verified on <?php echo date('F d, Y', strtotime($profile_data['admin_verified_at'])); ?>
                </p>
                <?php endif; ?>
                
                <div class="d-grid gap-2 d-md-flex justify-content-md-center mt-4">
                    <a href="properties.php" class="btn btn-primary btn-lg">
                        <i class="fas fa-building"></i> Browse Properties
                    </a>
                    <a href="apply.php" class="btn btn-success btn-lg">
                        <i class="fas fa-plus-circle"></i> New Application
                    </a>
                </div>
                
                <div class="alert alert-success mt-4 text-start">
                    <h6><i class="fas fa-star"></i> What You Can Do Now:</h6>
                    <ul class="mb-0">
                        <li>Browse available properties</li>
                        <li>Submit rental applications</li>
                        <li>Use the rent calculator</li>
                        <li>Contact property agents</li>
                        <li>Access all premium features</li>
                    </ul>
                </div>
            </div>
        </div>
        
    <?php else: ?>
        <!-- Rejected/Suspended -->
        <div class="card">
            <div class="card-body p-5">
                <div class="status-icon rejected">
                    <i class="fas fa-times-circle"></i>
                </div>
                
                <h2 class="mb-3">Verification Issues</h2>
                <p class="text-muted mb-4">
                    Unfortunately, we encountered some issues with your profile verification.
                </p>
                
                <?php if (!empty($profile_data['rejection_reason'])): ?>
                <div class="alert alert-danger text-start">
                    <h6><i class="fas fa-exclamation-triangle"></i> Reason:</h6>
                    <p class="mb-0"><?php echo nl2br(htmlspecialchars($profile_data['rejection_reason'])); ?></p>
                </div>
                <?php endif; ?>
                
                <div class="alert alert-info text-start">
                    <h6><i class="fas fa-lightbulb"></i> Next Steps:</h6>
                    <ul class="mb-0">
                        <li>Review the reason for rejection above</li>
                        <li>Update your profile with correct information</li>
                        <li>Ensure all documents are clear and valid</li>
                        <li>Resubmit your profile for verification</li>
                    </ul>
                </div>
                
                <div class="mt-4">
                    <a href="complete-profile.php" class="btn btn-warning btn-lg">
                        <i class="fas fa-edit"></i> Update Profile
                    </a>
                    <a href="profile.php" class="btn btn-outline-secondary btn-lg">
                        <i class="fas fa-user"></i> View Profile
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Help Section -->
    <div class="card mt-4">
        <div class="card-body">
            <h5 class="mb-3">Need Help?</h5>
            <p class="text-muted mb-3">
                If you have any questions about the verification process, our support team is here to help.
            </p>
            
            <div class="row g-3">
                <div class="col-md-4">
                    <a href="mailto:support@rovo.com" class="btn btn-outline-primary w-100">
                        <i class="fas fa-envelope"></i><br>
                        <small>Email Support</small>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="https://wa.me/2349065136669" target="_blank" class="btn btn-outline-success w-100">
                        <i class="fab fa-whatsapp"></i><br>
                        <small>WhatsApp</small>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="tel:+2349065136669" class="btn btn-outline-info w-100">
                        <i class="fas fa-phone"></i><br>
                        <small>Call Us</small>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>